<?php
session_start();
require_once 'api/db.php';

$error = '';
$success = '';

if (isset($_SESSION['user_id'])) {
    header("Location: dashboard.php");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $full_name = $_POST['full_name'];
    $phone = $_POST['phone'];
    $password = $_POST['password'];
    $address = $_POST['address'];

    if (empty($full_name) || empty($phone) || empty($password) || empty($address)) {
        $error = 'لطفا تمام فیلدها را پر کنید';
    } else {
        // Check if phone exists
        $stmt = $conn->prepare("SELECT id FROM users WHERE phone = :phone");
        $stmt->bindParam(':phone', $phone);
        $stmt->execute();

        if ($stmt->rowCount() > 0) {
            $error = 'این شماره موبایل قبلا ثبت شده است';
        } else {
            // Register user
            $created_at = round(microtime(true) * 1000);
            $role = 'user';
            
            $query = "INSERT INTO users (full_name, phone, password, address, role, created_at) VALUES (:name, :phone, :pass, :addr, :role, :created)";
            $stmt = $conn->prepare($query);
            
            $params = [
                ':name' => $full_name,
                ':phone' => $phone,
                ':pass' => password_hash($password, PASSWORD_DEFAULT),
                ':addr' => $address,
                ':role' => $role,
                ':created' => $created_at
            ];

            if ($stmt->execute($params)) {
                // Auto login
                $_SESSION['user_id'] = $conn->lastInsertId();
                $_SESSION['full_name'] = $full_name;
                $_SESSION['role'] = $role;
                $_SESSION['phone'] = $phone;
                
                header("Location: dashboard.php");
                exit();
            } else {
                $error = 'خطا در ثبت نام. لطفا مجددا تلاش کنید.';
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ثبت نام حساب کاربری</title>
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- FontAwesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Google Fonts: Vazirmatn -->
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@100..900&display=swap" rel="stylesheet">
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Vazirmatn', 'sans-serif'],
                    },
                    colors: {
                        brand: {
                            50: '#eff6ff',
                            100: '#dbeafe',
                            500: '#3b82f6',
                            600: '#2563eb',
                            700: '#1d4ed8',
                            900: '#1e3a8a',
                        }
                    }
                }
            }
        }
    </script>
    <style>
        .pattern-grid {
            background-image: radial-gradient(#ffffff 1px, transparent 1px);
            background-size: 30px 30px;
            opacity: 0.1;
        }
        /* Custom Scrollbar for Textarea */
        textarea::-webkit-scrollbar {
            width: 8px;
        }
        textarea::-webkit-scrollbar-track {
            background: #f1f1f1;
            border-radius: 8px;
        }
        textarea::-webkit-scrollbar-thumb {
            background: #cbd5e1;
            border-radius: 8px;
        }
        textarea::-webkit-scrollbar-thumb:hover {
            background: #94a3b8;
        }
    </style>
</head>
<body class="font-sans bg-gray-50 min-h-screen flex items-center justify-center p-0 sm:p-6">

    <div class="w-full max-w-6xl bg-white sm:rounded-[2rem] shadow-2xl overflow-hidden flex flex-col md:flex-row min-h-screen sm:min-h-[700px]">
        
        <!-- Right Side: Visual/Branding (Desktop Only) -->
        <div class="hidden md:flex w-1/2 bg-brand-700 relative flex-col justify-between p-12 text-white overflow-hidden order-last md:order-first">
            <!-- Background Decorations -->
            <div class="absolute inset-0 bg-gradient-to-br from-brand-600 to-indigo-900 opacity-90"></div>
            <div class="absolute inset-0 pattern-grid"></div>
            <div class="absolute -top-24 -right-24 w-80 h-80 bg-blue-400 rounded-full mix-blend-overlay filter blur-3xl opacity-20"></div>
            <div class="absolute bottom-24 -left-24 w-96 h-96 bg-purple-500 rounded-full mix-blend-overlay filter blur-3xl opacity-20"></div>

            <!-- Content -->
            <div class="relative z-10">
                <div class="w-12 h-12 bg-white/20 rounded-xl flex items-center justify-center backdrop-blur-sm mb-6">
                    <i class="fa-solid fa-user-plus text-2xl"></i>
                </div>
                <h2 class="text-4xl font-bold mb-4 leading-tight">شروع یک تجربه<br>متفاوت و حرفه‌ای</h2>
                <p class="text-blue-100 text-lg opacity-90 leading-relaxed">
                    با ایجاد حساب کاربری، به سادگی سفارشات خود را ثبت کنید، وضعیت آن‌ها را پیگیری کنید و از خدمات ویژه ما بهره‌مند شوید.
                </p>
            </div>

            <div class="relative z-10 space-y-4">
                <div class="flex items-center gap-3 text-blue-100 bg-white/10 p-3 rounded-xl backdrop-blur-sm border border-white/10">
                    <div class="w-8 h-8 rounded-full bg-green-400 flex items-center justify-center text-brand-900">
                        <i class="fa-solid fa-check text-sm"></i>
                    </div>
                    <span class="text-sm font-medium">ثبت سفارش آنلاین در کمتر از ۱ دقیقه</span>
                </div>
                <div class="flex items-center gap-3 text-blue-100 bg-white/10 p-3 rounded-xl backdrop-blur-sm border border-white/10">
                    <div class="w-8 h-8 rounded-full bg-green-400 flex items-center justify-center text-brand-900">
                        <i class="fa-solid fa-check text-sm"></i>
                    </div>
                    <span class="text-sm font-medium">پیگیری لحظه‌ای وضعیت سفارش</span>
                </div>
            </div>
        </div>

        <!-- Left Side: Form -->
        <div class="w-full md:w-1/2 p-8 sm:p-12 lg:p-14 flex flex-col justify-center bg-white relative overflow-y-auto">
            
            <div class="max-w-md w-full mx-auto">
                <div class="text-center md:text-right mb-8">
                    <h1 class="text-3xl font-extrabold text-gray-900 mb-2">ایجاد حساب جدید</h1>
                    <p class="text-gray-500">اطلاعات خود را برای تکمیل ثبت نام وارد کنید</p>
                </div>

                <?php if($error): ?>
                    <div class="flex items-center p-4 mb-6 text-sm text-red-800 border border-red-300 rounded-xl bg-red-50 animate-pulse" role="alert">
                        <i class="fa-solid fa-circle-exclamation ml-3 text-lg"></i>
                        <span class="font-medium"><?php echo $error; ?></span>
                    </div>
                <?php endif; ?>

                <form method="POST" action="" class="space-y-5">
                    
                    <!-- Full Name -->
                    <div class="space-y-1">
                        <label class="text-sm font-medium text-gray-700 block">نام و نام خانوادگی</label>
                        <div class="relative group">
                            <div class="absolute inset-y-0 right-0 flex items-center pr-4 pointer-events-none text-gray-400 group-focus-within:text-brand-600 transition-colors">
                                <i class="fa-solid fa-user"></i>
                            </div>
                            <input type="text" name="full_name" class="block w-full pr-11 pl-4 py-3 bg-gray-50 border border-gray-200 rounded-xl text-gray-900 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-brand-500/20 focus:border-brand-500 focus:bg-white transition-all" placeholder="مثال: علی محمدی" required value="<?php echo isset($_POST['full_name']) ? htmlspecialchars($_POST['full_name']) : ''; ?>">
                        </div>
                    </div>

                    <!-- Phone -->
                    <div class="space-y-1">
                        <label class="text-sm font-medium text-gray-700 block">شماره موبایل</label>
                        <div class="relative group">
                            <div class="absolute inset-y-0 right-0 flex items-center pr-4 pointer-events-none text-gray-400 group-focus-within:text-brand-600 transition-colors">
                                <i class="fa-solid fa-mobile-screen-button"></i>
                            </div>
                            <input type="tel" name="phone" class="block w-full pr-11 pl-4 py-3 bg-gray-50 border border-gray-200 rounded-xl text-gray-900 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-brand-500/20 focus:border-brand-500 focus:bg-white transition-all text-left md:text-right" dir="ltr" placeholder="0912..." required value="<?php echo isset($_POST['phone']) ? htmlspecialchars($_POST['phone']) : ''; ?>">
                        </div>
                    </div>

                    <!-- Password -->
                    <div class="space-y-1">
                        <label class="text-sm font-medium text-gray-700 block">رمز عبور</label>
                        <div class="relative group">
                            <div class="absolute inset-y-0 right-0 flex items-center pr-4 pointer-events-none text-gray-400 group-focus-within:text-brand-600 transition-colors">
                                <i class="fa-solid fa-lock"></i>
                            </div>
                            <input type="password" name="password" class="block w-full pr-11 pl-4 py-3 bg-gray-50 border border-gray-200 rounded-xl text-gray-900 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-brand-500/20 focus:border-brand-500 focus:bg-white transition-all" placeholder="••••••••" required>
                        </div>
                    </div>

                    <!-- Address -->
                    <div class="space-y-1">
                        <label class="text-sm font-medium text-gray-700 block">آدرس دقیق</label>
                        <div class="relative group">
                            <div class="absolute top-3 right-0 flex pr-4 pointer-events-none text-gray-400 group-focus-within:text-brand-600 transition-colors">
                                <i class="fa-solid fa-map-location-dot"></i>
                            </div>
                            <textarea name="address" class="block w-full pr-11 pl-4 py-3 bg-gray-50 border border-gray-200 rounded-xl text-gray-900 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-brand-500/20 focus:border-brand-500 focus:bg-white transition-all h-24 resize-none" placeholder="آدرس محل دریافت و تحویل سفارش..." required><?php echo isset($_POST['address']) ? htmlspecialchars($_POST['address']) : ''; ?></textarea>
                        </div>
                    </div>

                    <!-- Submit Button -->
                    <button type="submit" class="w-full flex justify-center py-3.5 px-4 border border-transparent rounded-xl shadow-lg text-sm font-bold text-white bg-gradient-to-r from-brand-600 to-brand-700 hover:from-brand-700 hover:to-brand-800 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-brand-500 transition-all transform hover:-translate-y-0.5 active:translate-y-0 mt-2">
                        تکمیل ثبت نام
                        <i class="fa-solid fa-check mr-2 mt-1"></i>
                    </button>
                </form>

                <div class="mt-6 text-center border-t border-gray-100 pt-6">
                    <p class="text-sm text-gray-600">
                        قبلاً ثبت نام کرده‌اید؟ 
                        <a href="login.php" class="font-bold text-brand-600 hover:text-brand-500 mr-1 hover:underline transition-all">وارد شوید</a>
                    </p>
                    <div class="mt-4">
                        <a href="index.php" class="inline-flex items-center text-xs text-gray-400 hover:text-gray-600 transition-colors">
                            <i class="fa-solid fa-house ml-1"></i>
                            بازگشت به خانه
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

</body>
</html>
