<?php
session_start();
header("Cache-Control: no-cache, no-store, must-revalidate");
require_once '../../api/db.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header("Location: ../../login.php");
    exit();
}

$orderId = $_GET['id'] ?? null;
if (!$orderId) {
    header("Location: admin.php");
    exit();
}

try {
    $stmt = $conn->prepare("SELECT * FROM orders WHERE id = ?");
    $stmt->execute([$orderId]);
    $order = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$order) {
        header("Location: admin.php");
        exit();
    }
    
    $services = $conn->query("SELECT * FROM services ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
} catch(PDOException $e) {
    header("Location: admin.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ویرایش سفارش | پنل مدیریت</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        [x-cloak] { display:none !important; }
        body { font-family: 'Vazirmatn', sans-serif; }
        .datepicker-popup {
            position: absolute;
            z-index: 9999;
            background: white;
            border: 1px solid #e2e8f0;
            border-radius: 1rem;
            box-shadow: 0 10px 25px rgba(0,0,0,0.1);
            padding: 1rem;
            min-width: 280px;
        }
    </style>
</head>
<body class="bg-gray-50" x-data="editOrder()" x-init="init()">

<div class="min-h-screen p-6">
    <div class="max-w-4xl mx-auto">
        <div class="bg-white rounded-2xl shadow-lg p-6 mb-6">
            <div class="flex items-center justify-between mb-6">
                <div>
                    <h1 class="text-2xl font-bold text-zinc-900">ویرایش سفارش</h1>
                    <p class="text-sm text-zinc-500 mt-1">کد پیگیری: <span class="font-mono"><?php echo $order['tracking_code']; ?></span></p>
                </div>
                <a href="admin.php" class="px-4 py-2 bg-zinc-100 hover:bg-zinc-200 rounded-lg text-sm font-medium transition-colors">
                    <i class="fa-solid fa-arrow-right ml-2"></i>بازگشت
                </a>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                <div>
                    <label class="block text-sm font-medium text-zinc-700 mb-2">نام مشتری</label>
                    <input type="text" x-model="customer.name" class="w-full px-4 py-2 border border-zinc-200 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 outline-none">
                </div>
                <div>
                    <label class="block text-sm font-medium text-zinc-700 mb-2">شماره تماس</label>
                    <input type="tel" x-model="customer.phone" class="w-full px-4 py-2 border border-zinc-200 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 outline-none text-left dir-ltr">
                </div>
                <div class="md:col-span-2">
                    <label class="block text-sm font-medium text-zinc-700 mb-2">آدرس</label>
                    <textarea x-model="customer.address" rows="2" class="w-full px-4 py-2 border border-zinc-200 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 outline-none resize-none"></textarea>
                </div>
                <div>
                    <label class="block text-sm font-medium text-zinc-700 mb-2">تاریخ تحویل (اختیاری)</label>
                    <div class="relative">
                        <input type="text" x-model="deliveryDate" @click="showDatePicker = true" readonly placeholder="انتخاب تاریخ تحویل" class="w-full px-4 py-2 border border-zinc-200 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 outline-none text-center cursor-pointer">
                        <i class="fa-solid fa-calendar-days absolute left-3 top-1/2 -translate-y-1/2 text-zinc-400 pointer-events-none"></i>
                    </div>
                </div>
                <div>
                    <label class="block text-sm font-medium text-zinc-700 mb-2">وضعیت</label>
                    <select x-model="status" class="w-full px-4 py-2 border border-zinc-200 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 outline-none">
                        <option value="pending">در انتظار</option>
                        <option value="processing">در حال شستشو</option>
                        <option value="ready">آماده تحویل</option>
                        <option value="delivered">تحویل شده</option>
                        <option value="cancelled">لغو شده</option>
                    </select>
                </div>
                <div class="md:col-span-2">
                    <label class="block text-sm font-medium text-zinc-700 mb-2">یادداشت</label>
                    <textarea x-model="notes" rows="2" class="w-full px-4 py-2 border border-zinc-200 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 outline-none resize-none"></textarea>
                </div>
            </div>

            <div class="mb-6">
                <h3 class="text-lg font-bold text-zinc-900 mb-4">اقلام سفارش</h3>
                <div class="space-y-2">
                    <template x-for="(item, index) in cart" :key="index">
                        <div class="flex items-center gap-4 p-3 bg-zinc-50 rounded-lg">
                            <div class="flex-1">
                                <p class="font-medium text-zinc-900" x-text="item.name"></p>
                                <p class="text-sm text-zinc-500"><span x-text="formatNumber(item.price)"></span> تومان</p>
                            </div>
                            <div class="flex items-center gap-2">
                                <button @click="item.qty++" class="w-8 h-8 bg-blue-500 text-white rounded-lg hover:bg-blue-600">
                                    <i class="fa-solid fa-plus text-xs"></i>
                                </button>
                                <span class="w-8 text-center font-bold" x-text="item.qty"></span>
                                <button @click="item.qty > 1 ? item.qty-- : cart.splice(index, 1)" class="w-8 h-8 bg-red-500 text-white rounded-lg hover:bg-red-600">
                                    <i class="fa-solid fa-minus text-xs"></i>
                                </button>
                            </div>
                            <p class="font-bold text-zinc-900 w-32 text-left"><span x-text="formatNumber(item.price * item.qty)"></span> ت</p>
                        </div>
                    </template>
                </div>
            </div>

            <div class="flex items-center justify-between pt-6 border-t border-zinc-200">
                <div>
                    <p class="text-sm text-zinc-500">مجموع</p>
                    <p class="text-2xl font-black text-zinc-900"><span x-text="formatNumber(totalPrice)"></span> تومان</p>
                </div>
                <button @click="updateOrder()" :disabled="isLoading" class="px-6 py-3 bg-blue-600 hover:bg-blue-700 text-white font-bold rounded-lg disabled:opacity-50 transition-colors">
                    <i class="fa-solid" :class="isLoading ? 'fa-circle-notch fa-spin' : 'fa-check'" class="ml-2"></i>
                    <span x-text="isLoading ? 'در حال ذخیره...' : 'ذخیره تغییرات'"></span>
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Date Picker Modal -->
<div x-show="showDatePicker" @click.self="showDatePicker = false" class="fixed inset-0 z-[9999] flex items-center justify-center bg-black/30 backdrop-blur-sm" x-cloak>
    <div class="bg-white rounded-2xl shadow-2xl p-6 w-80" @click.stop>
        <div class="flex items-center justify-between mb-4 pb-3 border-b border-zinc-200">
            <button type="button" @click="prevMonth()" class="w-9 h-9 rounded-xl hover:bg-zinc-100 flex items-center justify-center transition-colors">
                <i class="fa-solid fa-chevron-right"></i>
            </button>
            <span class="font-bold text-lg" x-text="monthNames[currentMonth] + ' ' + currentYear"></span>
            <button type="button" @click="nextMonth()" class="w-9 h-9 rounded-xl hover:bg-zinc-100 flex items-center justify-center transition-colors">
                <i class="fa-solid fa-chevron-left"></i>
            </button>
        </div>
        <div class="grid grid-cols-7 gap-1 mb-2">
            <template x-for="day in ['ش','ی','د','س','چ','پ','ج']">
                <div class="text-center text-xs font-bold text-zinc-400 py-2" x-text="day"></div>
            </template>
        </div>
        <div class="grid grid-cols-7 gap-1">
            <template x-for="(day, index) in calendarDays" :key="index">
                <button type="button" @click="selectDate(day)" 
                     :class="{
                         'aspect-square flex items-center justify-center rounded-lg text-sm transition-all': true,
                         'bg-blue-500 text-white font-bold': day.selected,
                         'border-2 border-blue-500': day.isToday && !day.selected,
                         'opacity-30 cursor-not-allowed': day.disabled || !day.currentMonth,
                         'hover:bg-zinc-100': !day.disabled && day.currentMonth && !day.selected,
                         'text-zinc-300': !day.currentMonth,
                         'text-zinc-700': day.currentMonth
                     }"
                     :disabled="day.disabled || !day.currentMonth"
                     x-text="day.day"></button>
            </template>
        </div>
    </div>
</div>

<script>
function editOrder() {
    return {
        orderId: <?php echo $orderId; ?>,
        customer: {
            name: <?php echo json_encode($order['customer_name']); ?>,
            phone: <?php echo json_encode($order['customer_phone']); ?>,
            address: <?php echo json_encode($order['customer_address']); ?>
        },
        deliveryDate: <?php echo json_encode($order['delivery_date']); ?>,
        status: <?php echo json_encode($order['status']); ?>,
        notes: <?php echo json_encode($order['notes']); ?>,
        cart: <?php echo $order['items_json']; ?>,
        isLoading: false,
        showDatePicker: false,
        currentYear: 1403,
        currentMonth: 9,
        selectedDate: null,
        monthNames: ['فروردین','اردیبهشت','خرداد','تیر','مرداد','شهریور','مهر','آبان','آذر','دی','بهمن','اسفند'],
        calendarDays: [],

        init() {
            const today = new Date();
            const jToday = this.gregorianToJalali(today.getFullYear(), today.getMonth() + 1, today.getDate());
            this.currentYear = jToday[0];
            this.currentMonth = jToday[1] - 1;
            this.loadCalendar();
        },

        get totalPrice() {
            return this.cart.reduce((sum, item) => sum + (item.price * item.qty), 0);
        },

        formatNumber(num) {
            return new Intl.NumberFormat('fa-IR').format(num);
        },

        loadCalendar() {
            const days = [];
            const daysInMonth = this.currentMonth < 6 ? 31 : (this.currentMonth < 11 ? 30 : 29);
            const jDate = this.jalaliToGregorian(this.currentYear, this.currentMonth + 1, 1);
            const gDate = new Date(jDate[0], jDate[1] - 1, jDate[2]);
            const firstDay = gDate.getDay() === 6 ? 0 : gDate.getDay() + 1;
            const today = new Date();
            const jToday = this.gregorianToJalali(today.getFullYear(), today.getMonth() + 1, today.getDate());
            for (let i = 0; i < firstDay; i++) days.push({ day: '', currentMonth: false });
            for (let i = 1; i <= daysInMonth; i++) {
                const dateStr = `${this.currentYear}/${String(this.currentMonth + 1).padStart(2, '0')}/${String(i).padStart(2, '0')}`;
                const isPast = (this.currentYear < jToday[0]) || (this.currentYear === jToday[0] && this.currentMonth + 1 < jToday[1]) || (this.currentYear === jToday[0] && this.currentMonth + 1 === jToday[1] && i < jToday[2]);
                days.push({ day: i, date: dateStr, currentMonth: true, selected: this.selectedDate === dateStr, isToday: this.isToday(i), disabled: isPast });
            }
            this.calendarDays = days;
        },

        isToday(day) {
            const today = new Date();
            const jToday = this.gregorianToJalali(today.getFullYear(), today.getMonth() + 1, today.getDate());
            return jToday[0] === this.currentYear && jToday[1] === this.currentMonth + 1 && jToday[2] === day;
        },

        selectDate(day) {
            if (!day.currentMonth || day.disabled) return;
            this.selectedDate = day.date;
            this.deliveryDate = day.date;
            this.showDatePicker = false;
        },

        prevMonth() { 
            this.currentMonth === 0 ? (this.currentMonth = 11, this.currentYear--) : this.currentMonth--;
            this.loadCalendar();
        },

        nextMonth() { 
            this.currentMonth === 11 ? (this.currentMonth = 0, this.currentYear++) : this.currentMonth++;
            this.loadCalendar();
        },

        gregorianToJalali(gy, gm, gd) {
            const g_d_m = [0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334];
            const gy2 = (gm > 2) ? (gy + 1) : gy;
            let days = 355666 + (365 * gy) + Math.floor((gy2 + 3) / 4) - Math.floor((gy2 + 99) / 100) + Math.floor((gy2 + 399) / 400) + gd + g_d_m[gm - 1];
            let jy = -1595 + (33 * Math.floor(days / 12053));
            days %= 12053;
            jy += 4 * Math.floor(days / 1461);
            days %= 1461;
            if (days > 365) {
                jy += Math.floor((days - 1) / 365);
                days = (days - 1) % 365;
            }
            const jm = (days < 186) ? 1 + Math.floor(days / 31) : 7 + Math.floor((days - 186) / 30);
            const jd = 1 + ((days < 186) ? (days % 31) : ((days - 186) % 30));
            return [jy, jm, jd];
        },

        jalaliToGregorian(jy, jm, jd) {
            jy += 1595;
            let days = 365 * jy + Math.floor(jy / 33) * 8 + Math.floor((jy % 33 + 3) / 4) + 78 + jd + ((jm < 7) ? (jm - 1) * 31 : ((jm - 7) * 30) + 186);
            let gy = 400 * Math.floor(days / 146097);
            days %= 146097;
            let flag = true;
            if (days >= 36525) {
                days--;
                gy += 100 * Math.floor(days / 36524);
                days %= 36524;
                if (days >= 365) days++;
                else flag = false;
            }
            if (flag) {
                gy += 4 * Math.floor(days / 1461);
                days %= 1461;
                if (days >= 366) {
                    flag = false;
                    days--;
                    gy += Math.floor(days / 365);
                    days = days % 365;
                }
            }
            const sal_a = [0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334];
            const gm = sal_a.findIndex((v, i) => days < (i < 11 ? sal_a[i + 1] : 366)) + 1;
            const gd = days - sal_a[gm - 1] + 1;
            return [gy, gm, gd];
        },

        async updateOrder() {
            if (!this.customer.name || !this.customer.phone) {
                alert('لطفا نام و شماره تماس را وارد کنید');
                return;
            }

            this.isLoading = true;
            const payload = {
                customer_name: this.customer.name,
                customer_phone: this.customer.phone,
                customer_address: this.customer.address,
                delivery_date: this.deliveryDate,
                status: this.status,
                notes: this.notes,
                items_json: JSON.stringify(this.cart),
                total_price: this.totalPrice
            };

            try {
                const res = await fetch(`../../api/orders.php?id=${this.orderId}`, {
                    method: 'PATCH',
                    headers: {'Content-Type': 'application/json'},
                    body: JSON.stringify(payload)
                });

                if (res.ok) {
                    alert('سفارش با موفقیت بروزرسانی شد');
                    window.location.href = 'admin.php';
                } else {
                    throw new Error('Update failed');
                }
            } catch (e) {
                alert('خطا در بروزرسانی سفارش');
                this.isLoading = false;
            }
        }
    }
}
</script>
</body>
</html>
