<?php
session_start();
require_once 'api/db.php';

$error = '';
$success = '';

if (isset($_SESSION['user_id'])) {
    if ($_SESSION['role'] === 'admin') {
        header("Location: pages/admin/admin.php");
    } else {
        header("Location: pages/user/dashboard.php");
    }
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $phone = $_POST['phone'];
    $password = $_POST['password'];

    if (empty($phone) || empty($password)) {
        $error = 'لطفا تمام فیلدها را پر کنید';
    } else {
        $stmt = $conn->prepare("SELECT * FROM users WHERE phone = :phone");
        $stmt->bindParam(':phone', $phone);
        $stmt->execute();
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        $is_valid = false;
        if ($user) {
            if ($user['password'] === $password) {
                $is_valid = true;
            } elseif (password_verify($password, $user['password'])) {
                $is_valid = true;
            }
        }

        if ($is_valid) {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['full_name'] = $user['full_name'];
            $_SESSION['role'] = $user['role'];
            $_SESSION['phone'] = $user['phone'];

            if ($user['role'] === 'admin') {
                header("Location: pages/admin/admin.php");
            } else {
                header("Location: pages/user/dashboard.php");
            }
            exit();
        } else {
            $error = 'شماره موبایل یا رمز عبور اشتباه است';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ورود به پنل کاربری</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@100..900&display=swap" rel="stylesheet">
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Vazirmatn', 'sans-serif'],
                    },
                    colors: {
                        brand: {
                            50: '#eff6ff',
                            100: '#dbeafe',
                            500: '#3b82f6',
                            600: '#2563eb',
                            700: '#1d4ed8',
                            900: '#1e3a8a',
                        }
                    }
                }
            }
        }
    </script>
    <style>
        .glass-effect {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
        }
        .pattern-grid {
            background-image: radial-gradient(#ffffff 1px, transparent 1px);
            background-size: 30px 30px;
            opacity: 0.1;
        }
    </style>
</head>
<body class="font-sans bg-gray-50 min-h-screen flex items-center justify-center p-0 sm:p-6">

    <div class="w-full max-w-6xl bg-white sm:rounded-[2rem] shadow-2xl overflow-hidden flex flex-col md:flex-row min-h-screen sm:min-h-[600px]">
        
        <div class="hidden md:flex w-1/2 bg-brand-700 relative flex-col justify-between p-12 text-white overflow-hidden">
            <div class="absolute inset-0 bg-gradient-to-br from-brand-600 to-indigo-900 opacity-90"></div>
            <div class="absolute inset-0 pattern-grid"></div>
            <div class="absolute -top-24 -right-24 w-80 h-80 bg-blue-400 rounded-full mix-blend-overlay filter blur-3xl opacity-20"></div>
            <div class="absolute -bottom-24 -left-24 w-80 h-80 bg-purple-500 rounded-full mix-blend-overlay filter blur-3xl opacity-20"></div>

            <div class="relative z-10">
                <div class="w-12 h-12 bg-white/20 rounded-xl flex items-center justify-center backdrop-blur-sm mb-6">
                    <i class="fa-solid fa-layer-group text-2xl"></i>
                </div>
                <h2 class="text-4xl font-bold mb-4 leading-tight">مدیریت هوشمند<br>کسب و کار شما</h2>
                <p class="text-blue-100 text-lg opacity-90">به پنل مدیریت اختصاصی خود خوش آمدید. برای دسترسی به امکانات، لطفا وارد شوید.</p>
            </div>

            <div class="relative z-10 flex gap-4 text-sm text-blue-200">
                <span><i class="fa-solid fa-shield-halved ml-2"></i>امنیت بالا</span>
                <span><i class="fa-solid fa-bolt ml-2"></i>سرعت عالی</span>
            </div>
        </div>

        <div class="w-full md:w-1/2 p-8 sm:p-12 lg:p-16 flex flex-col justify-center bg-white relative">
            
            <div class="max-w-md w-full mx-auto">
                <div class="text-center md:text-right mb-10">
                    <h1 class="text-3xl font-extrabold text-gray-900 mb-2">ورود به حساب</h1>
                    <p class="text-gray-500">اطلاعات کاربری خود را وارد کنید</p>
                </div>

                <?php if($error): ?>
                    <div class="flex items-center p-4 mb-6 text-sm text-red-800 border border-red-300 rounded-xl bg-red-50 animate-pulse" role="alert">
                        <i class="fa-solid fa-circle-exclamation ml-3 text-lg"></i>
                        <span class="font-medium"><?php echo $error; ?></span>
                    </div>
                <?php endif; ?>

                <form method="POST" action="" class="space-y-6">
                    <div class="space-y-2">
                        <label for="phone" class="text-sm font-medium text-gray-700 block">شماره موبایل</label>
                        <div class="relative group">
                            <div class="absolute inset-y-0 right-0 flex items-center pr-4 pointer-events-none text-gray-400 group-focus-within:text-brand-600 transition-colors">
                                <i class="fa-solid fa-mobile-screen-button"></i>
                            </div>
                            <input type="tel" name="phone" id="phone" 
                                class="block w-full pr-11 pl-4 py-3.5 bg-gray-50 border border-gray-200 rounded-xl text-gray-900 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-brand-500/20 focus:border-brand-500 focus:bg-white transition-all duration-200 text-left md:text-right" 
                                placeholder="0912..." 
                                dir="ltr"
                                value="<?php echo isset($_POST['phone']) ? htmlspecialchars($_POST['phone']) : ''; ?>" required>
                        </div>
                    </div>

                    <div class="space-y-2">
                        <div class="flex justify-between items-center">
                            <label for="password" class="text-sm font-medium text-gray-700 block">رمز عبور</label>
                            <a href="reset_password.php" class="text-xs font-medium text-brand-600 hover:text-brand-800 transition-colors">رمز عبور را فراموش کردهاید؟</a>
                        </div>
                        <div class="relative group">
                            <div class="absolute inset-y-0 right-0 flex items-center pr-4 pointer-events-none text-gray-400 group-focus-within:text-brand-600 transition-colors">
                                <i class="fa-solid fa-lock-open"></i>
                            </div>
                            <input type="password" name="password" id="password" 
                                class="block w-full pr-11 pl-4 py-3.5 bg-gray-50 border border-gray-200 rounded-xl text-gray-900 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-brand-500/20 focus:border-brand-500 focus:bg-white transition-all duration-200" 
                                placeholder="••••••••" required>
                        </div>
                    </div>

                    <button type="submit" class="w-full flex justify-center py-4 px-4 border border-transparent rounded-xl shadow-lg text-sm font-bold text-white bg-gradient-to-r from-brand-600 to-brand-700 hover:from-brand-700 hover:to-brand-800 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-brand-500 transition-all transform hover:-translate-y-0.5 active:translate-y-0">
                        ورود به سامانه
                        <i class="fa-solid fa-arrow-left mr-2 mt-1"></i>
                    </button>
                </form>

                <div class="mt-8 text-center border-t border-gray-100 pt-6">
                    <p class="text-sm text-gray-600">
                        هنوز ثبت نام نکردهاید؟ 
                        <a href="register.php" class="font-bold text-brand-600 hover:text-brand-500 mr-1 hover:underline transition-all">ایجاد حساب کاربری</a>
                    </p>
                    <div class="mt-4">
                        <a href="index.php" class="inline-flex items-center text-xs text-gray-400 hover:text-gray-600 transition-colors">
                            <i class="fa-solid fa-house ml-1"></i>
                            بازگشت به خانه
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

</body>
</html>
