<?php
require_once 'api/db.php';

try {
    // 1. Create Tables
    $sql = "
    CREATE TABLE IF NOT EXISTS `users` (
      `id` int(11) NOT NULL AUTO_INCREMENT,
      `full_name` varchar(100) NOT NULL,
      `phone` varchar(20) NOT NULL,
      `password` varchar(255) NOT NULL,
      `address` text NOT NULL,
      `role` enum('user','admin') NOT NULL DEFAULT 'user',
      `created_at` bigint(20) NOT NULL,
      PRIMARY KEY (`id`),
      UNIQUE KEY `phone` (`phone`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;

    CREATE TABLE IF NOT EXISTS `services` (
      `id` int(11) NOT NULL AUTO_INCREMENT,
      `name` varchar(100) NOT NULL,
      `price` decimal(10,0) NOT NULL,
      `icon` varchar(50) NOT NULL,
      PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;

    CREATE TABLE IF NOT EXISTS `orders` (
      `id` int(11) NOT NULL AUTO_INCREMENT,
      `user_id` int(11) NOT NULL,
      `items_json` longtext NOT NULL,
      `total_price` decimal(15,0) NOT NULL,
      `status` enum('pending','processing','ready','delivered','cancelled') NOT NULL DEFAULT 'pending',
      `notes` text,
      `created_at` bigint(20) NOT NULL,
      PRIMARY KEY (`id`),
      KEY `user_id` (`user_id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;
    ";
    
    $conn->exec($sql);
    echo "<p style='color:green'>Tables created or already exist.</p>";

    // 2. Insert Admin if not exists
    $stmt = $conn->prepare("SELECT id FROM users WHERE phone = '09121234567'");
    $stmt->execute();
    if (!$stmt->fetch()) {
        $pass = 'admin123'; // Plain text based on your previous sql, normally hash it
        $conn->exec("INSERT INTO `users` (`full_name`, `phone`, `password`, `address`, `role`, `created_at`) VALUES
        ('مدیر سیستم', '09121234567', 'admin123', 'دفتر مرکزی', 'admin', 1703750000000)");
        echo "<p style='color:green'>Default admin created.</p>";
    }

    // 3. Insert Services if empty
    $stmt = $conn->query("SELECT count(*) FROM services");
    $count = $stmt->fetchColumn();
    
    if ($count == 0) {
        $services = [
            ['پیراهن مردانه', 50000, 'fa-shirt'],
            ['شلوار', 60000, 'fa-layer-group'],
            ['کت و شلوار', 180000, 'fa-user-tie'],
            ['کاپشن / پالتو', 150000, 'fa-snowflake'],
            ['پتو یک نفره', 120000, 'fa-bed'],
            ['پرده (هر پنل)', 80000, 'fa-dungeon'],
            ['مانتو', 70000, 'fa-vest'],
            ['چادر', 65000, 'fa-person-dress'],
            ['کیف و کفش', 90000, 'fa-shoe-prints']
        ];
        
        $insertSql = "INSERT INTO services (name, price, icon) VALUES (?, ?, ?)";
        $stmt = $conn->prepare($insertSql);
        
        foreach ($services as $s) {
            $stmt->execute($s);
        }
        echo "<p style='color:green'>Services inserted successfully.</p>";
    } else {
        echo "<p style='color:blue'>Services already exist. Skipped.</p>";
    }

    echo "<h1>Installation Completed Successfully!</h1>";
    echo "<a href='index.php'>Go to Home</a>";

} catch(PDOException $e) {
    echo "<h2 style='color:red'>Error: " . $e->getMessage() . "</h2>";
}
