<?php
header('Content-Type: application/json; charset=UTF-8');
require_once 'db.php';

function sendSMS($phone, $message) {
    global $conn;
    
    // دریافت تنظیمات پیامک
    $stmt = $conn->prepare("SELECT setting_key, setting_value FROM settings WHERE setting_key IN ('sms_provider', 'sms_username', 'sms_password', 'sms_sender', 'sms_enabled')");
    $stmt->execute();
    $settings = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $settings[$row['setting_key']] = $row['setting_value'];
    }
    
    // بررسی فعال بودن پیامک
    if (empty($settings['sms_enabled']) || $settings['sms_enabled'] != '1') {
        return ['success' => false, 'message' => 'SMS disabled'];
    }
    
    if (empty($settings['sms_username']) || empty($settings['sms_password']) || empty($settings['sms_sender'])) {
        return ['success' => false, 'message' => 'SMS not configured'];
    }
    
    // پاکسازی شماره
    $phone = preg_replace('/\D/', '', $phone);
    if (strlen($phone) == 11 && $phone[0] == '0') {
        $phone = substr($phone, 1);
    }
    if (strlen($phone) == 10) {
        $phone = '0' . $phone;
    }
    
    $provider = $settings['sms_provider'] ?? 'melipayamak';
    
    if ($provider == 'melipayamak') {
        // ملی پیامک
        $url = "https://rest.payamak-panel.com/api/SendSMS/SendSMS";
        $data = [
            'username' => $settings['sms_username'],
            'password' => $settings['sms_password'],
            'to' => $phone,
            'from' => $settings['sms_sender'],
            'text' => $message,
            'isFlash' => false
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($httpCode == 200) {
            $result = json_decode($response, true);
            if (isset($result['Value']) && $result['Value'] > 0) {
                return ['success' => true, 'message' => 'SMS sent'];
            }
        }
        return ['success' => false, 'message' => 'SMS failed', 'response' => $response];
        
    } else {
        // کاوه نگار
        if (strlen($phone) == 11 && $phone[0] == '0') {
            $phone = '98' . substr($phone, 1);
        }
        
        $url = "https://api.kavenegar.com/v1/" . $settings['sms_username'] . "/sms/send.json";
        $data = [
            'sender' => $settings['sms_sender'],
            'receptor' => $phone,
            'message' => $message
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($httpCode == 200) {
            return ['success' => true, 'message' => 'SMS sent'];
        }
        return ['success' => false, 'message' => 'SMS failed', 'response' => $response];
    }
}

// تست ارسال پیامک
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents("php://input"), true);
    
    if (isset($data['phone']) && isset($data['message'])) {
        $result = sendSMS($data['phone'], $data['message']);
        echo json_encode($result);
    } else {
        echo json_encode(['success' => false, 'message' => 'Missing parameters']);
    }
}
?>
