<?php
// Persian Date Converter
if (!function_exists('gregorian_to_jalali')) {
function gregorian_to_jalali($gy, $gm, $gd) {
    $g_d_m = array(0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334);
    $gy2 = ($gm > 2) ? ($gy + 1) : $gy;
    $days = 355666 + (365 * $gy) + ((int)(($gy2 + 3) / 4)) - ((int)(($gy2 + 99) / 100)) + ((int)(($gy2 + 399) / 400)) + $gd + $g_d_m[$gm - 1];
    $jy = -1595 + (33 * ((int)($days / 12053)));
    $days %= 12053;
    $jy += 4 * ((int)($days / 1461));
    $days %= 1461;
    if ($days > 365) {
        $jy += (int)(($days - 1) / 365);
        $days = ($days - 1) % 365;
    }
    if ($days < 186) {
        $jm = 1 + (int)($days / 31);
        $jd = 1 + ($days % 31);
    } else {
        $jm = 7 + (int)(($days - 186) / 30);
        $jd = 1 + (($days - 186) % 30);
    }
    return array($jy, $jm, $jd);
}
}

if (!function_exists('getPersianDate')) {
function getPersianDate($format = 'Y/m/d H:i', $timestamp = null) {
    if ($timestamp === null) $timestamp = time();
    list($jy, $jm, $jd) = gregorian_to_jalali(date('Y', $timestamp), date('m', $timestamp), date('d', $timestamp));
    
    $jm = str_pad($jm, 2, '0', STR_PAD_LEFT);
    $jd = str_pad($jd, 2, '0', STR_PAD_LEFT);
    $hour = date('H', $timestamp);
    $minute = date('i', $timestamp);
    
    $result = str_replace('Y', $jy, $format);
    $result = str_replace('m', $jm, $result);
    $result = str_replace('d', $jd, $result);
    $result = str_replace('H', $hour, $result);
    $result = str_replace('i', $minute, $result);
    
    return $result;
}
}

if (!function_exists('toPersianNum')) {
function toPersianNum($num) {
    $persian = ['۰','۱','۲','۳','۴','۵','۶','۷','۸','۹'];
    $english = ['0','1','2','3','4','5','6','7','8','9'];
    return str_replace($english, $persian, $num);
}
}
?>
