<?php
require_once 'includes/system.php';
$msg='';$type='';
if($_SERVER['REQUEST_METHOD']==='POST'){
$code=trim($_POST['code']??'');
if($code){
$r=System::activate($code);
$msg=$r['message'];
$type=$r['success']?'success':'error';
if($r['success'])header('refresh:2;url=index.php');
}else{
$msg='لطفا کد را وارد کنید';
$type='error';
}}
$d=System::domain();
$ip=$_SERVER['SERVER_ADDR']??'';
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>فعالسازی</title>
<script src="https://cdn.tailwindcss.com"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
<style>@import url('https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;600;700&display=swap');*{font-family:'Vazirmatn',sans-serif;}.gradient-bg{background:linear-gradient(135deg,#667eea 0%,#764ba2 100%);}</style>
</head>
<body class="bg-gray-50 min-h-screen flex items-center justify-center p-4">
<div class="max-w-lg w-full">
<div class="bg-white rounded-2xl shadow-2xl overflow-hidden">
<div class="gradient-bg text-white p-8 text-center">
<div class="w-16 h-16 bg-white bg-opacity-20 rounded-full flex items-center justify-center mx-auto mb-4">
<i class="fas fa-key text-3xl"></i>
</div>
<h1 class="text-2xl font-bold">فعالسازی سیستم</h1>
<p class="text-purple-100 mt-2">کد فعالسازی را وارد کنید</p>
</div>
<div class="p-8">
<?php if($msg):?>
<div class="mb-6 p-4 rounded-xl <?=$type==='success'?'bg-green-50 border-r-4 border-green-500':'bg-red-50 border-r-4 border-red-500'?>">
<div class="flex items-center gap-3">
<i class="fas <?=$type==='success'?'fa-check-circle text-green-500':'fa-exclamation-circle text-red-500'?> text-xl"></i>
<p class="<?=$type==='success'?'text-green-700':'text-red-700'?>"><?=htmlspecialchars($msg)?></p>
</div>
</div>
<?php endif;?>
<div class="bg-gradient-to-r from-blue-50 to-purple-50 rounded-xl p-5 mb-6">
<h3 class="font-bold text-gray-800 mb-3 flex items-center gap-2">
<i class="fas fa-info-circle text-blue-600"></i>
اطلاعات سیستم
</h3>
<div class="space-y-2 text-sm">
<div class="flex justify-between items-center">
<span class="text-gray-600">دامنه:</span>
<code class="bg-white px-3 py-1 rounded-lg text-purple-600 font-semibold"><?=htmlspecialchars($d)?></code>
</div>
<div class="flex justify-between items-center">
<span class="text-gray-600">IP سرور:</span>
<code class="bg-white px-3 py-1 rounded-lg text-purple-600 font-semibold"><?=htmlspecialchars($ip)?></code>
</div>
</div>
</div>
<form method="POST" class="space-y-5">
<div>
<label class="block text-gray-700 font-semibold mb-2">
<i class="fas fa-ticket-alt text-purple-600 ml-2"></i>
کد فعالسازی
</label>
<textarea name="code" rows="4" required placeholder="کد را اینجا وارد کنید..." class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:border-purple-500 focus:outline-none transition-all font-mono text-sm"></textarea>
</div>
<button type="submit" class="w-full gradient-bg text-white px-6 py-4 rounded-xl font-bold hover:shadow-2xl transition-all transform hover:scale-105">
<i class="fas fa-unlock ml-2"></i>
فعالسازی
</button>
</form>
</div>
</div>
</div>
</body>
</html>
