<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>پیگیری سفارش | پاکشور</title>

    <!-- Tailwind -->
    <script src="https://cdn.tailwindcss.com"></script>

    <!-- Font Awesome -->
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- Vazirmatn Font -->
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;600;700;800&display=swap"
          rel="stylesheet">

    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: { sans: ['Vazirmatn', 'sans-serif'] },
                    colors: {
                        primary: {
                            50: '#eff6ff',
                            100: '#dbeafe',
                            500: '#3b82f6',
                            600: '#2563eb',
                            700: '#1d4ed8'
                        },
                        emerald: {
                            50: '#ecfdf5',
                            500: '#10b981',
                            600: '#059669'
                        }
                    },
                    boxShadow: {
                        'glass': '0 18px 45px rgba(15, 23, 42, 0.08)'
                    }
                }
            }
        }
    </script>

    <style>
        body {
            font-family: "Vazirmatn", system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
        }
        html {
            scroll-behavior: smooth;
        }
        input[type=number]::-webkit-inner-spin-button,
        input[type=number]::-webkit-outer-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }
    </style>
</head>

<body class="bg-gradient-to-br from-slate-50 via-white to-emerald-50 min-h-screen text-slate-900">

<!-- پس‌زمینه نرم -->
<div class="fixed inset-0 -z-10 overflow-hidden pointer-events-none">
    <div class="absolute -right-20 -top-32 w-80 h-80 bg-primary-200/70 rounded-full blur-3xl"></div>
    <div class="absolute -left-24 top-40 w-96 h-96 bg-emerald-200/60 rounded-full blur-3xl"></div>
    <div class="absolute inset-0 bg-[radial-gradient(circle_at_top,_rgba(255,255,255,0.9),_transparent_60%)]"></div>
</div>

<!-- Header -->
<header class="sticky top-0 z-40 border-b border-slate-200/70 bg-white/80 backdrop-blur-xl">
    <div class="max-w-5xl mx-auto px-4 sm:px-6 py-3 flex items-center justify-between">
        <a href="../../index.php" class="flex items-center gap-2 sm:gap-3">
            <div
                class="w-10 h-10 sm:w-11 sm:h-11 rounded-2xl bg-gradient-to-br from-primary-500 to-emerald-500 flex items-center justify-center text-white shadow-glass">
                <i class="fa-solid fa-soap text-lg"></i>
            </div>
            <div class="flex flex-col">
                <span class="font-bold text-base sm:text-lg text-slate-900 tracking-tight">پاکشور</span>
                <span class="text-[11px] sm:text-xs text-slate-500">خشکشویی آنلاین | تحویل درب منزل</span>
            </div>
        </a>

        <a href="../../index.php"
           class="inline-flex items-center gap-1 rounded-full bg-slate-50 px-3 py-1.5 text-xs sm:text-sm text-slate-700 border border-slate-200 hover:bg-slate-100 transition">
            <i class="fa-solid fa-home text-[11px] sm:text-xs ml-1"></i>
            صفحه اصلی
        </a>
    </div>
</header>

<!-- Main -->
<main class="px-4 sm:px-6 py-8 sm:py-12">
    <div class="max-w-5xl mx-auto flex flex-col lg:flex-row gap-8 lg:gap-10 items-stretch">

        <!-- Left: Intro / Hero -->
        <section class="lg:w-5/12 space-y-6 text-center lg:text-right">
            <div class="inline-flex items-center gap-2 rounded-full bg-primary-50 border border-primary-100 px-3 py-1 text-[11px] sm:text-xs text-primary-700">
                <span class="w-5 h-5 rounded-full bg-primary-500 flex items-center justify-center text-[11px] text-white">
                    <i class="fa-solid fa-bolt"></i>
                </span>
                پیگیری سریع و آنلاین وضعیت سفارش خشکشویی
            </div>

            <div class="space-y-3">
                <h1 class="text-2xl sm:text-3xl md:text-4xl font-extrabold text-slate-900 leading-relaxed sm:leading-snug">
                    پیگیری وضعیت سفارش
                    <span class="text-emerald-600">پاکشور</span>
                </h1>
                <p class="text-slate-600 text-sm sm:text-base leading-relaxed">
                    با وارد کردن
                    <span class="font-semibold text-slate-900">شماره پیگیری</span>
                    و
                    <span class="font-semibold text-slate-900">شماره موبایل</span>
                    می‌توانید آخرین وضعیت شستشو، آماده‌سازی و تحویل سفارش خود را مشاهده کنید.
                </p>
            </div>

            <!-- مزایا -->
            <div class="grid grid-cols-2 gap-3 text-xs sm:text-sm text-slate-700 mt-2 sm:mt-4">
                <div class="flex items-center gap-2">
                    <span class="w-7 h-7 rounded-full bg-emerald-50 border border-emerald-200 flex items-center justify-center text-emerald-600 text-xs">
                        <i class="fa-solid fa-clock"></i>
                    </span>
                    <span>پیگیری لحظه‌ای وضعیت سفارش</span>
                </div>
                <div class="flex items-center gap-2">
                    <span class="w-7 h-7 rounded-full bg-primary-50 border border-primary-200 flex items-center justify-center text-primary-600 text-xs">
                        <i class="fa-solid fa-truck-fast"></i>
                    </span>
                    <span>نمایش وضعیت تحویل و ارسال</span>
                </div>
                <div class="flex items-center gap-2">
                    <span class="w-7 h-7 rounded-full bg-slate-50 border border-slate-200 flex items-center justify-center text-slate-700 text-xs">
                        <i class="fa-solid fa-receipt"></i>
                    </span>
                    <span>مشاهده مبلغ و جزئیات سفارش</span>
                </div>
                <div class="flex items-center gap-2">
                    <span class="w-7 h-7 rounded-full bg-pink-50 border border-pink-200 flex items-center justify-center text-pink-600 text-xs">
                        <i class="fa-solid fa-shield-check"></i>
                    </span>
                    <span>امنیت اطلاعات و حریم خصوصی</span>
                </div>
            </div>

            <!-- Hint -->
            <p class="text-xs sm:text-sm text-slate-600 border border-slate-200 bg-white rounded-2xl px-4 py-3 inline-flex items-start gap-2 mt-4 shadow-sm">
                <i class="fa-solid fa-circle-info mt-0.5 text-sky-500"></i>
                <span>
                    شماره پیگیری برای شما از طریق پیامک ارسال شده است. در صورت عدم دریافت، با پشتیبانی پاکشور تماس بگیرید.
                </span>
            </p>
        </section>

        <!-- Right: Form + Result -->
        <section class="lg:w-7/12 space-y-5 sm:space-y-6">
            <!-- Card -->
            <div
                class="bg-white border border-slate-200 rounded-3xl shadow-glass p-5 sm:p-7">

                <!-- عنوان فرم -->
                <div class="text-center mb-5 sm:mb-7">
                    <div
                        class="w-14 h-14 sm:w-16 sm:h-16 mx-auto mb-3 rounded-2xl bg-gradient-to-br from-primary-500 to-emerald-500 flex items-center justify-center text-white shadow-md">
                        <i class="fa-solid fa-magnifying-glass text-xl sm:text-2xl"></i>
                    </div>
                    <h2 class="text-lg sm:text-xl font-bold text-slate-900 mb-1">
                        پیگیری سفارش
                    </h2>
                    <p class="text-slate-500 text-xs sm:text-sm">
                        لطفاً شماره پیگیری و شماره موبایل خود را وارد کنید
                    </p>
                </div>

                <!-- Form -->
                <form id="tracking-form" class="space-y-6">
                    <!-- Tracking Code -->
                    <div class="space-y-2">
                        <label class="flex items-center gap-1.5 text-xs sm:text-sm text-slate-800 font-medium">
                            <i class="fa-solid fa-barcode ml-1 text-primary-500"></i>
                            شماره پیگیری
                        </label>

                        <div class="flex flex-wrap items-center justify-center gap-2" dir="ltr">
                            <template id="tracking-box-template">
                                <input type="text" maxlength="1"
                                       class="w-9 h-11 sm:w-10 sm:h-12 md:w-11 md:h-14 text-center border border-slate-200 bg-slate-50 text-slate-900 rounded-xl text-base sm:text-lg font-bold outline-none focus:border-primary-500 focus:ring-2 focus:ring-primary-200 transition-colors tracking-[0.2em]"
                                       inputmode="numeric" pattern="[0-9]*">
                            </template>

                            <div id="tracking-boxes"
                                 class="flex items-center justify-center gap-2"></div>
                        </div>

                        <p class="text-[11px] sm:text-xs text-slate-500 text-center mt-1">
                            مثال شماره پیگیری:
                            <span class="font-mono text-slate-800 bg-slate-100 px-2 py-0.5 rounded-lg">
                                140410-1234
                            </span>
                        </p>
                        <input type="hidden" id="tracking-code" required>
                    </div>

                    <!-- Phone -->
                    <div class="space-y-2">
                        <label class="flex items-center gap-1.5 text-xs sm:text-sm text-slate-800 font-medium">
                            <i class="fa-solid fa-mobile-screen ml-1 text-emerald-500"></i>
                            شماره موبایل
                        </label>
                        <input type="tel" id="tracking-phone" required
                               inputmode="tel"
                               class="w-full px-4 py-3.5 sm:py-4 border border-slate-200 rounded-2xl bg-slate-50 text-center text-sm sm:text-base text-slate-900 font-mono tracking-wide outline-none focus:border-emerald-500 focus:ring-2 focus:ring-emerald-200 transition"
                               placeholder="09xxxxxxxxx" dir="ltr">
                        <p class="text-[11px] sm:text-xs text-slate-500">
                            شماره موبایل باید همان شماره ثبت‌شده هنگام ثبت سفارش باشد.
                        </p>
                    </div>

                    <!-- Submit -->
                    <button type="submit"
                            class="w-full inline-flex items-center justify-center gap-2 bg-gradient-to-r from-primary-600 to-emerald-600 text-white py-3.5 sm:py-4 rounded-2xl font-bold text-sm sm:text-base shadow-md hover:shadow-lg hover:from-primary-500 hover:to-emerald-500 active:scale-[0.99] transition">
                        <i class="fa-solid fa-magnifying-glass ml-1"></i>
                        پیگیری سفارش
                    </button>
                </form>
            </div>

            <!-- Result Container -->
            <div id="tracking-result" class="space-y-4 hidden"></div>
        </section>
    </div>
</main>

<!-- Footer -->
<footer class="border-t border-slate-200 bg-white/90 backdrop-blur-xl mt-8">
    <div class="max-w-5xl mx-auto px-4 sm:px-6 py-4 sm:py-5 flex flex-col sm:flex-row items-center justify-between gap-3 text-[11px] sm:text-xs text-slate-500">
        <p>
            &copy; ۱۴۰۳ پاکشور – خشکشویی آنلاین | تمامی حقوق محفوظ است.
        </p>
        <div class="flex items-center gap-3 text-[11px]">
            <span class="inline-flex items-center gap-1">
                <i class="fa-solid fa-headset text-emerald-500 text-[11px]"></i>
                پشتیبانی: ۲۴ ساعته
            </span>
            <span class="hidden sm:inline-block w-px h-3 bg-slate-300"></span>
            <span class="inline-flex items-center gap-1">
                <i class="fa-solid fa-lock text-primary-500 text-[11px]"></i>
                اتصال امن و رمزنگاری‌شده
            </span>
        </div>
    </div>
</footer>

<script>
    // --- ساخت داینامیک باکس‌های کد پیگیری (۶ رقم + ۴ رقم) ---
    const boxesContainer = document.getElementById('tracking-boxes');
    const boxTemplate = document.getElementById('tracking-box-template');

    const TOTAL_BOXES = 10; // 140410-1234

    const boxes = [];
    for (let i = 0; i < TOTAL_BOXES; i++) {
        if (i === 6) {
            // جداکننده -
            const dash = document.createElement('span');
            dash.textContent = '-';
            dash.className = 'text-lg sm:text-xl font-bold text-slate-400 mx-1';
            boxesContainer.appendChild(dash);
        }
        const clone = boxTemplate.content.firstElementChild.cloneNode(true);
        clone.dataset.index = i.toString();
        const example = '1404101234';
        clone.placeholder = example[i] || '';
        boxesContainer.appendChild(clone);
        boxes.push(clone);
    }

    function updateTrackingCode() {
        const values = boxes.map(b => (b.value || '').replace(/[^0-9]/g, ''));
        const code = values.slice(0, 6).join('') + '-' + values.slice(6).join('');
        document.getElementById('tracking-code').value = code;
    }

    boxes.forEach((box, index) => {
        box.addEventListener('input', (e) => {
            const v = e.target.value.replace(/[^0-9]/g, '');
            e.target.value = v.slice(0, 1);

            if (v && index < boxes.length - 1) {
                boxes[index + 1].focus();
                boxes[index + 1].select();
            }
            updateTrackingCode();
        });

        box.addEventListener('keydown', (e) => {
            if (e.key === 'Backspace' && !e.target.value && index > 0) {
                boxes[index - 1].focus();
                boxes[index - 1].select();
            }
            if (e.key === 'ArrowLeft' && index < boxes.length - 1) {
                boxes[index + 1].focus();
            }
            if (e.key === 'ArrowRight' && index > 0) {
                boxes[index - 1].focus();
            }
        });

        box.addEventListener('paste', (e) => {
            e.preventDefault();
            const paste = (e.clipboardData.getData('text') || '')
                .replace(/[^0-9]/g, '')
                .slice(0, TOTAL_BOXES);

            paste.split('').forEach((char, i) => {
                if (boxes[i]) boxes[i].value = char;
            });
            if (paste.length > 0) {
                const lastIndex = Math.min(paste.length - 1, TOTAL_BOXES - 1);
                boxes[lastIndex].focus();
            }
            updateTrackingCode();
        });
    });

    // فوکوس روی اولین باکس هنگام لود
    if (boxes[0]) {
        setTimeout(() => {
            boxes[0].focus();
        }, 300);
    }

    // --- هندل فرم ---
    document.getElementById('tracking-form').addEventListener('submit', async (e) => {
        e.preventDefault();
        const trackingCode = document.getElementById('tracking-code').value.trim();
        const phone = document.getElementById('tracking-phone').value.trim();
        const resultDiv = document.getElementById('tracking-result');

        // ولیدیشن ساده
        if (!/^[0-9]{6}-[0-9]{4}$/.test(trackingCode)) {
            resultDiv.classList.remove('hidden');
            resultDiv.innerHTML = `
                <div class="bg-red-50 border border-red-200 rounded-2xl p-4 sm:p-5 text-center text-red-700">
                    <i class="fa-solid fa-exclamation-circle text-xl sm:text-2xl mb-2 text-red-500"></i>
                    <p class="font-semibold text-sm sm:text-base mb-1">فرمت شماره پیگیری صحیح نیست</p>
                    <p class="text-xs sm:text-sm">
                        لطفاً شماره پیگیری را به شکل
                        <span class="font-mono bg-red-50 px-2 py-0.5 rounded-lg border border-red-200">140410-1234</span>
                        وارد کنید.
                    </p>
                </div>
            `;
            return;
        }

        if (!/^09[0-9]{9}$/.test(phone)) {
            resultDiv.classList.remove('hidden');
            resultDiv.innerHTML = `
                <div class="bg-red-50 border border-red-200 rounded-2xl p-4 sm:p-5 text-center text-red-700">
                    <i class="fa-solid fa-phone-slash text-xl sm:text-2xl mb-2 text-red-500"></i>
                    <p class="font-semibold text-sm sm:text-base mb-1">شماره موبایل نامعتبر است</p>
                    <p class="text-xs sm:text-sm">
                        لطفاً شماره موبایل را با فرمت
                        <span class="font-mono bg-red-50 px-2 py-0.5 rounded-lg border border-red-200">09xxxxxxxxx</span>
                        وارد کنید.
                    </p>
                </div>
            `;
            return;
        }

        // Loading
        resultDiv.classList.remove('hidden');
        resultDiv.innerHTML = `
            <div class="bg-white border border-slate-200 rounded-2xl p-5 sm:p-6 text-center text-slate-700 shadow-sm">
                <div class="w-11 h-11 sm:w-12 sm:h-12 mx-auto mb-3 rounded-full bg-primary-50 flex items-center justify-center">
                    <i class="fa-solid fa-spinner fa-spin text-primary-500 text-lg sm:text-xl"></i>
                </div>
                <p class="text-sm sm:text-base">در حال جستجوی سفارش شما...</p>
                <p class="text-xs text-slate-400 mt-1">لطفاً چند لحظه صبر کنید</p>
            </div>
        `;

        try {
            const response = await fetch(`../../api/orders.php?action=track&tracking_code=${encodeURIComponent(trackingCode)}&phone=${encodeURIComponent(phone)}`);
            const data = await response.json();

            if (data && data.order) {
                const order = data.order;

                const statusMap = {
                    'pending': {
                        text: 'در انتظار بررسی',
                        color: 'bg-amber-50 border-amber-200 text-amber-800',
                        icon: 'fa-clock',
                        iconColor: 'text-amber-500',
                        step: 1
                    },
                    'processing': {
                        text: 'در حال شستشو',
                        color: 'bg-blue-50 border-blue-200 text-blue-800',
                        icon: 'fa-spinner fa-spin',
                        iconColor: 'text-blue-500',
                        step: 2
                    },
                    'ready': {
                        text: 'آماده تحویل',
                        color: 'bg-emerald-50 border-emerald-200 text-emerald-800',
                        icon: 'fa-check-circle',
                        iconColor: 'text-emerald-500',
                        step: 3
                    },
                    'delivered': {
                        text: 'تحویل داده شد',
                        color: 'bg-slate-50 border-slate-200 text-slate-800',
                        icon: 'fa-circle-check',
                        iconColor: 'text-slate-600',
                        step: 4
                    },
                    'cancelled': {
                        text: 'لغو شده',
                        color: 'bg-red-50 border-red-200 text-red-800',
                        icon: 'fa-times-circle',
                        iconColor: 'text-red-500',
                        step: 0
                    }
                };

                const statusInfo = statusMap[order.status] || statusMap['pending'];

                const steps = [
                    { key: 'pending', label: 'ثبت سفارش' },
                    { key: 'processing', label: 'در حال شستشو' },
                    { key: 'ready', label: 'آماده تحویل' },
                    { key: 'delivered', label: 'تحویل داده شد' }
                ];

                const currentStep = statusInfo.step;

                const stepsHtml = steps.map((s, idx) => {
                    const stepIndex = idx + 1;
                    const isDone = stepIndex <= currentStep;
                    const isCurrent = stepIndex === currentStep;

                    let circleClasses = 'w-7 h-7 rounded-full flex items-center justify-center text-xs border';
                    let lineClasses = 'flex-1 h-0.5';
                    let labelClasses = 'text-[10px] sm:text-xs mt-1 text-center';

                    if (currentStep === 0 && s.key === 'pending') {
                        circleClasses += ' border-slate-300 bg-slate-100 text-slate-500';
                        lineClasses += ' bg-slate-200';
                        labelClasses += ' text-slate-500';
                    } else if (isDone) {
                        circleClasses += ' border-emerald-500 bg-emerald-500 text-white';
                        lineClasses += ' bg-emerald-400';
                        labelClasses += ' text-emerald-700';
                    } else {
                        circleClasses += ' border-slate-300 bg-slate-100 text-slate-500';
                        lineClasses += ' bg-slate-200';
                        labelClasses += ' text-slate-400';
                    }

                    if (isCurrent && currentStep !== 0) {
                        circleClasses += ' ring-2 ring-emerald-200 ring-offset-2 ring-offset-white';
                    }

                    return `
                        <div class="flex-1 flex flex-col items-center">
                            <div class="flex items-center w-full">
                                ${idx !== 0 ? `<div class="${lineClasses}"></div>` : ''}
                                <div class="${circleClasses}">
                                    ${stepIndex}
                                </div>
                                ${idx !== steps.length - 1 ? `<div class="${lineClasses}"></div>` : ''}
                            </div>
                            <div class="${labelClasses}">${s.label}</div>
                        </div>
                    `;
                }).join('');

                resultDiv.innerHTML = `
                    <div class="bg-white border border-slate-200 rounded-3xl overflow-hidden shadow-glass">
                        <!-- Header -->
                        <div class="bg-gradient-to-r from-emerald-500 to-primary-500 px-5 sm:px-6 py-4 text-white flex flex-col sm:flex-row sm:items-center sm:justify-between gap-2">
                            <div class="flex items-center gap-3">
                                <div class="w-9 h-9 sm:w-10 sm:h-10 rounded-2xl bg-white/15 flex items-center justify-center">
                                    <i class="fa-solid fa-check text-lg"></i>
                                </div>
                                <div>
                                    <h3 class="text-sm sm:text-base font-bold">سفارش یافت شد</h3>
                                    <p class="text-[11px] sm:text-xs text-emerald-50/90">
                                        جزئیات سفارش در ادامه نمایش داده می‌شود
                                    </p>
                                </div>
                            </div>
                            <div class="text-xs sm:text-sm">
                                <span class="opacity-80">شماره پیگیری:</span>
                                <span class="font-mono bg-black/15 rounded-full px-3 py-1 ml-1 text-[11px] sm:text-xs">
                                    ${order.tracking_code}
                                </span>
                            </div>
                        </div>

                        <!-- Body -->
                        <div class="p-5 sm:p-6 space-y-5 sm:space-y-6">
                            <!-- Status & Date -->
                            <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-3">
                                <div class="flex-1 ${statusInfo.color} rounded-2xl px-4 py-3 sm:py-3.5 flex items-center justify-between text-xs sm:text-sm">
                                    <span class="font-semibold">وضعیت سفارش</span>
                                    <div class="flex items-center gap-2">
                                        <i class="fa-solid ${statusInfo.icon} ${statusInfo.iconColor}"></i>
                                        <span class="font-bold">${statusInfo.text}</span>
                                    </div>
                                </div>

                                <div class="flex-1 bg-slate-50 border border-slate-200 rounded-2xl px-4 py-3 text-xs sm:text-sm flex items-center justify-between">
                                    <span class="text-slate-600">تاریخ ثبت</span>
                                    <span class="font-semibold text-slate-900">
                                        ${new Date(parseInt(order.created_at)).toLocaleDateString('fa-IR')}
                                    </span>
                                </div>
                            </div>

                            <!-- Steps / Timeline -->
                            <div class="bg-slate-50 border border-slate-200 rounded-2xl px-4 py-4 sm:px-5 sm:py-5">
                                <div class="flex items-center gap-2 mb-3">
                                    <i class="fa-solid fa-route text-sky-500 text-xs sm:text-sm"></i>
                                    <p class="text-xs sm:text-sm text-slate-800 font-medium">
                                        مسیر وضعیت سفارش
                                    </p>
                                </div>
                                <div class="flex items-center gap-2 text-[10px] sm:text-xs">
                                    ${stepsHtml}
                                </div>
                            </div>

                            <!-- Info Grid -->
                            <div class="grid grid-cols-1 sm:grid-cols-2 gap-3 sm:gap-4 text-xs sm:text-sm">
                                <div class="flex flex-col gap-1 bg-slate-50 border border-slate-200 rounded-2xl p-3.5">
                                    <span class="text-slate-500">نام مشتری</span>
                                    <span class="font-semibold text-slate-900">
                                        ${order.customer_name || 'نامشخص'}
                                    </span>
                                </div>

                                <div class="flex flex-col gap-1 bg-slate-50 border border-slate-200 rounded-2xl p-3.5">
                                    <span class="text-slate-500">شماره موبایل</span>
                                    <span class="font-mono text-slate-900">
                                        ${phone}
                                    </span>
                                </div>

                                <div class="flex flex-col gap-1 bg-slate-50 border border-slate-200 rounded-2xl p-3.5">
                                    <span class="text-slate-500">مبلغ کل</span>
                                    <span class="font-bold text-emerald-600">
                                        ${new Intl.NumberFormat('fa-IR').format(order.total_price)} تومان
                                    </span>
                                </div>

                                <div class="flex flex-col gap-1 bg-slate-50 border border-slate-200 rounded-2xl p-3.5">
                                    <span class="text-slate-500">کد سفارش داخلی</span>
                                    <span class="font-mono text-slate-900">
                                        ${order.id || '—'}
                                    </span>
                                </div>
                            </div>

                            <!-- Notes -->
                            ${order.notes ? `
                                <div class="bg-sky-50 border border-sky-200 rounded-2xl p-3.5 sm:p-4">
                                    <span class="text-[11px] sm:text-xs text-sky-700 font-semibold flex items-center gap-1">
                                        <i class="fa-solid fa-note-sticky text-sky-500 text-xs"></i>
                                        یادداشت سفارش
                                    </span>
                                    <p class="text-xs sm:text-sm text-sky-800 mt-2 leading-relaxed">
                                        ${order.notes}
                                    </p>
                                </div>
                            ` : ''}

                        </div>
                    </div>
                `;
            } else {
                resultDiv.innerHTML = `
                    <div class="bg-red-50 border border-red-200 rounded-3xl overflow-hidden text-red-800 shadow-sm">
                        <div class="bg-gradient-to-r from-red-500 to-pink-500 px-5 sm:px-6 py-4 text-white text-center">
                            <i class="fa-solid fa-triangle-exclamation text-xl sm:text-2xl mb-1"></i>
                            <h3 class="text-sm sm:text-base font-bold">سفارش یافت نشد</h3>
                        </div>
                        <div class="p-4 sm:p-5 text-center space-y-3">
                            <p class="text-xs sm:text-sm">
                                سفارشی با این مشخصات در سیستم ثبت نشده است.
                            </p>
                            <div class="bg-red-100 border border-red-200 rounded-2xl px-4 py-3 text-[11px] sm:text-xs text-red-800 space-y-1.5 text-right">
                                <p>لطفاً موارد زیر را بررسی کنید:</p>
                                <ul class="list-disc list-inside space-y-0.5">
                                    <li>صحت ارقام شماره پیگیری</li>
                                    <li>صحت شماره موبایل (همان شماره ثبت سفارش)</li>
                                    <li>گذشت چند دقیقه از ثبت سفارش (برای ثبت در سیستم)</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                `;
            }
        } catch (error) {
            console.error(error);
            resultDiv.innerHTML = `
                <div class="bg-red-50 border border-red-200 rounded-2xl p-5 sm:p-6 text-center text-red-700 shadow-sm">
                    <i class="fa-solid fa-wifi text-2xl sm:text-3xl text-red-500 mb-3"></i>
                    <p class="font-bold text-sm sm:text-base">خطا در اتصال به سرور</p>
                    <p class="text-xs sm:text-sm mt-2">
                        لطفاً اتصال اینترنت خود را بررسی کنید و دوباره تلاش کنید.
                    </p>
                </div>
            `;
        }
    });
</script>
</body>
</html>
