// Authentication Logic

const AUTH_KEY = 'dryclean_user';

function login(user) {
    // Legacy client-side support if needed, but main logic is now PHP session
    localStorage.setItem(AUTH_KEY, JSON.stringify(user));
    window.location.href = user.role === 'admin' ? 'admin.php' : 'dashboard.php';
}

function logout() {
    localStorage.removeItem(AUTH_KEY);
    window.location.href = 'logout.php';
}

function getCurrentUser() {
    const userStr = localStorage.getItem(AUTH_KEY);
    return userStr ? JSON.stringify(JSON.parse(userStr)) : null;
}

function getParsedUser() {
    const userStr = localStorage.getItem(AUTH_KEY);
    return userStr ? JSON.parse(userStr) : null;
}

function checkAuth(requiredRole = null) {
    // This is now handled by PHP at the top of files, so this client-side check is redundant but kept for safety.
    return true;
}

// Update Navbar based on Auth state
function updateNavbar() {
    // Navbar is now server-side rendered by PHP
}
