-- Database Name: khoshkshoei

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+03:30";

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `full_name` varchar(100) COLLATE utf8mb4_persian_ci NOT NULL,
  `phone` varchar(20) COLLATE utf8mb4_persian_ci NOT NULL,
  `password` varchar(255) COLLATE utf8mb4_persian_ci NOT NULL,
  `address` text COLLATE utf8mb4_persian_ci NOT NULL,
  `role` enum('user','admin') COLLATE utf8mb4_persian_ci NOT NULL DEFAULT 'user',
  `created_at` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `phone` (`phone`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;

--
-- Dumping data for table `users`
-- Admin: 09121234567 / admin123
--

INSERT INTO `users` (`id`, `full_name`, `phone`, `password`, `address`, `role`, `created_at`) VALUES
(1, 'مدیر سیستم', '09121234567', 'admin123', 'دفتر مرکزی', 'admin', 1703750000000);

-- --------------------------------------------------------

--
-- Table structure for table `services`
--

CREATE TABLE `services` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_persian_ci NOT NULL,
  `price` decimal(10,0) NOT NULL,
  `icon` varchar(50) COLLATE utf8mb4_persian_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;

--
-- Dumping data for table `services`
--

INSERT INTO `services` (`name`, `price`, `icon`) VALUES
('پیراهن مردانه', 50000, 'fa-shirt'),
('شلوار', 60000, 'fa-layer-group'),
('کت و شلوار', 180000, 'fa-user-tie'),
('کاپشن / پالتو', 150000, 'fa-snowflake'),
('پتو یک نفره', 120000, 'fa-bed'),
('پرده (هر پنل)', 80000, 'fa-dungeon'),
('مانتو', 70000, 'fa-vest'),
('چادر', 65000, 'fa-person-dress'),
('کیف و کفش', 90000, 'fa-shoe-prints');

-- --------------------------------------------------------

--
-- Table structure for table `orders`
--

CREATE TABLE `orders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `tracking_code` varchar(50) COLLATE utf8mb4_persian_ci DEFAULT NULL,
  `customer_name` varchar(100) COLLATE utf8mb4_persian_ci DEFAULT NULL,
  `customer_phone` varchar(20) COLLATE utf8mb4_persian_ci DEFAULT NULL,
  `customer_address` text COLLATE utf8mb4_persian_ci,
  `items_json` longtext COLLATE utf8mb4_persian_ci NOT NULL,
  `total_price` decimal(15,0) NOT NULL,
  `status` enum('pending','processing','ready','delivered','cancelled') COLLATE utf8mb4_persian_ci NOT NULL DEFAULT 'pending',
  `notes` text COLLATE utf8mb4_persian_ci,
  `created_at` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `tracking_code` (`tracking_code`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;

COMMIT;
