<?php
// اسکریپت بروزرسانی کدهای پیگیری
require_once 'db.php';

try {
    // دریافت تمام سفارشات
    $stmt = $conn->query("SELECT id, tracking_code FROM orders");
    $orders = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    $updated = 0;
    
    foreach ($orders as $order) {
        $code = $order['tracking_code'];
        
        // بررسی فرمت قدیمی (مثلاً 0310-1234 یا 140410-2019)
        if (preg_match('/^(\d{4})-(\d{4})$/', $code, $matches)) {
            $yearMonth = $matches[1];
            $random = $matches[2];
            
            // اگر سال 4 رقمی نیست، تبدیل کن
            if (strlen($yearMonth) == 4 && $yearMonth[0] == '0') {
                // فرمت قدیمی: 0310 -> 140310
                $newYearMonth = '14' . $yearMonth;
                $newCode = $newYearMonth . '-' . $random;
                
                // بروزرسانی
                $updateStmt = $conn->prepare("UPDATE orders SET tracking_code = ? WHERE id = ?");
                $updateStmt->execute([$newCode, $order['id']]);
                $updated++;
            }
        }
    }
    
    echo json_encode([
        'success' => true,
        'message' => "$updated کد پیگیری بروزرسانی شد",
        'total' => count($orders)
    ]);
    
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>
